
#IFDEF __STORY_DEBUG__
	Print __Alisha_._Project & " DevKit " & __Alisha_._Version_Pretty & " Core / Code / KVP22 / All-In-One"
	WaitKey ( )

#ENDIF

Const KVP_DB_GET = 1
Const KVP_DB_SET = 2

Const KVP_DB_POP = 4
Const KVP_DB_CLR = 8

Type KVP_Database
	As Long iterator
	As String label, value
	As FB.Image Ptr image
End Type

Dim Shared As KVP_Database Bogus, Report

With Bogus
	.iterator = -1
	.label = ""
	.value = ""
	.image = 0
End With

Report = Bogus

Dim Shared As String KVP_Text_Buffer
KVP_Text_Buffer = ""

Declare Sub __Save ( KVP_DB ( Any ) As KVP_Database, Filename As String = "" )

Declare Sub __Load ( KVP_DB ( Any ) As KVP_Database, Filename As String = "" )

Declare Sub __Set Overload ( KVP_DB ( Any ) As KVP_Database, PIndex AS Long = 0, Label As String = "", Value As String = "")

Declare Sub __Set Overload ( KVP_DB ( Any ) As KVP_Database, PIndex AS Long = 0, Label As String = "", Value As Long = 0 )

Declare Sub __Set Overload ( KVP_DB ( Any ) As KVP_Database, PIndex AS Long = 0, Label As String = "", Value As FB.Image Ptr )

Declare Function __Get ( KVP_DB ( Any ) As KVP_Database, Label As String = "" ) As KVP_Database

Declare Function KVP_Get ( KVP_DB ( Any ) As KVP_Database, Label As String = "" ) As KVP_Database

Declare Function KVP_Set ( KVP_DB ( Any ) As KVP_Database, Label As String = "", Value As String = "" ) As KVP_Database

Declare Sub KVP_Inc_Capacity ( KVP_DB ( Any ) As KVP_Database, Counter As Long = 1 )

Declare Function KVP_DB_CRLF_Buffer ( Buffer As String = "" ) As String

Declare Sub KVP_Digest_Word ( KVP_DB ( Any ) As KVP_Database, Buffer As String = "" )

Declare Sub KVP_Show_Array_Direct ( KVP_DB ( Any ) As KVP_Database )

Declare Sub KVP_Show_Array_Bounds ( KVP_DB ( Any ) As KVP_Database )

Declare Sub KVP_Show_Array ( KVP_DB ( Any ) As KVP_Database, ByRef Buff As String = "", ByRef Image As FB.Image Ptr = 0 )

Declare Sub KVP_Bubble_Sort ( KVP_DB ( Any ) As KVP_Database )

Declare Sub __Sort ( KVP_DB ( Any ) As KVP_Database )

Declare Function KVP_Binary_Find ( KVP_DB ( Any ) As KVP_Database, sName As String = "", ByRef WhereToAdd As Long = 0 ) As Long

Declare Function KVP_Database_Query ( KVP_DB ( Any ) As KVP_Database, sName As String = "" ) As KVP_Database

Declare Function KVP_Database_Set Overload ( KVP_DB ( Any ) As KVP_Database, sName As String = "", sValue As String = "" ) As Long

Declare Function KVP_Database_Set Overload ( KVP_DB ( Any ) As KVP_Database , sName As String = "" , sValue As LongInt = 0 ) As Long

Declare Function KVP_Database_Set Overload ( KVP_DB ( Any ) As KVP_Database , sName As String = "" , sValue As FB.Image Ptr ) As Long

Declare Function KVP_Database_Delete ( KVP_DB ( Any ) As KVP_Database, sName As String = "" ) As Long

	Declare Sub KVP_Database_Save ( KVP_DB ( Any ) As KVP_Database, filename As String = "" )

	Declare Sub KVP_Database_Load ( KVP_DB ( Any ) As KVP_Database, filename As String = "" )
	
Declare Function KVP_Database_Export ( KVP_DB ( Any ) As KVP_Database, Buffer As String = "" ) As String

Declare Sub KVP_Database_Import ( KVP_DB ( Any ) As KVP_Database, Buffer As String = "" )
	
	Declare Sub KVP_Save_Raw_Buffer ( Buffer As String = "", filename As String = "" )

	Declare Sub KVP_Load_Raw_Buffer ( Buffer As String = "", filename As String = "")

Declare Function __Buffer ( ShortPath As String = "", ShortFilename As String = "" ) As String

Declare Sub __Set_Sleep ( Index As Long = 0, Message As String = "", Value As String = "" ) 

Declare Function __Direct_Buffer ( FullFilename As String = "" ) As String

Sub __Set Overload ( KVP_DB ( Any ) As KVP_Database, PIndex AS Long = 0, Label As String = "", Value As String = "" )
	
	__Set_Sleep ( PIndex, Str_Replace ( VARSEP, SP & VARSEP & SP, Label ), Value )

	/' [!] The following line is broken somehow [!] '/
	'''''KVP_Database_Set ( KVP_DB ( ), PageIndex ( PIndex ) & VARSEP & Label, Value )
	
End Sub

Sub __Set Overload ( KVP_DB ( Any ) As KVP_Database, PIndex AS Long = 0, Label As String = "", Value As Long = 0 )

	__Set ( KVP_DB ( ), PIndex, Label, Str ( Value ) )
	
End Sub

Sub __Set Overload ( KVP_DB ( Any ) As KVP_Database, PIndex AS Long = 0, Label As String = "", Value As FB.Image Ptr )

	__Set ( KVP_DB ( ), PIndex, Label, Str ( @Value ) )
	
End Sub

Function __Get ( KVP_DB ( Any ) As KVP_Database, Label As String = "" ) As KVP_Database
	Return KVP_Get ( KVP_DB ( ), Label )
End Function

Sub __Save ( KVP_DB ( Any ) As KVP_Database, ShortFilename As String = "" )

	KVP_Database_Save ( KVP_DB ( ), "..\Story Six (v6-0-1)\Gamepacks\Story 7\Assets\KVP\" & ShortFilename & ".KVP" )

End Sub

Sub __Load ( KVP_DB ( Any ) As KVP_Database, ShortFilename As String = "" )

	KVP_Database_Load ( KVP_DB ( ), "..\Story Six (v6-0-1)\Gamepacks\Story 7\Assets\KVP\" & ShortFilename & ".KVP" )

End Sub

Function KVP_Get ( KVP_DB ( Any ) As KVP_Database, Label As String = "" ) As KVP_Database

	Dim As KVP_Database Request
	
	With Request
		
		.label = Label
		Request = KVP_Database_Query ( KVP_DB ( ), .label )
	
	End With
	
	Return Request
	
End Function

Function KVP_Set ( KVP_DB ( Any ) As KVP_Database, Label As String = "", Value As String = "" ) As KVP_Database

	Dim As KVP_Database Request
	
	With Request
		
		.label = Label
		.value = Value
		
		.iterator = KVP_Database_Set ( KVP_DB ( ), .label , .value )
		
		.value = KVP_DB ( .iterator ) .value
		.image = KVP_DB ( .iterator ) .image
	
	End With
	
	Return Request
	
End Function



Sub KVP_Inc_Capacity ( KVP_DB ( Any ) As KVP_Database, Counter As Long = 1 )

	Select Case Counter
	Case Is > 0
	
		Do While Counter > 0
			
			If UBound ( KVP_DB, 1 ) = -1 Then
				ReDim KVP_DB ( 0 To 0 )
			Else
				ReDim Preserve KVP_DB ( 0 To UBound( KVP_DB, 1 ) + 1 )
			End If
			
			Counter -= 1
			
		Loop
		
	Case Is < 0
	
		Do While Counter < 0
			
			If UBound( KVP_DB, 1 ) = 0 Then

				ReDim KVP_DB ( -1 To -1 )
				
				Exit Do
				
			Else
				
				Redim Preserve KVP_DB ( 0 To UBound( KVP_DB, 1 ) - 1 )
			
			End If
			
			Counter += 1
			
		Loop
		
	End Select
	
End Sub

Function KVP_DB_CRLF_Buffer ( Buffer As String = "" ) As String

	If Len ( Buffer ) > 0 Then
		Buffer &= CRLF
	End If

	Return Buffer

End Function

Sub KVP_Erase ( KVP_DB ( Any ) As KVP_Database )

	For Index As Long = UBound ( KVP_DB, 1 ) To 0 Step -1

		With KVP_DB ( Index )
			
			.label = ""
			.value = ""
			.image = ImageDestroy2 ( .image )
			.iterator = -1
		
		End With
		
		If Index > 0 Then
			ReDim Preserve KVP_DB ( 0 To Index - 1 )
		Else
			ReDim KVP_DB ( -1 To -1 )
		End If
	
	Next Index

End Sub

Sub KVP_Digest_Word ( KVP_DB ( Any ) As KVP_Database, Buffer As String = "" )

	KVP_Erase KVP_DB ( )
	
	Do While Len( Buffer ) > 0
		
		If strpos( CRLF, Buffer ) < strpos( Chr(32), Buffer ) Then
			
			KVP_Inc_Capacity( KVP_DB ( ), 1 )

			With KVP_DB( UBound( KVP_DB, 1 ) )
				.Iterator = -1
				.label = Hex( UBound( KVP_DB, 1 ) + 1 )
				.value = Prefix( CRLF, Buffer )
			End With

			Buffer = Suffix( CRLF, Buffer )

			KVP_Inc_Capacity( KVP_DB ( ), 1 )

			With KVP_DB( UBound( KVP_DB, 1 ) )
				.Iterator = -1
				.label = Hex( UBound( KVP_DB, 1 ) + 1 )
				.value = "{% CRLF %}"
			End With
			
		Else
			
			KVP_Inc_Capacity( KVP_DB ( ), 1 )

			With KVP_DB( UBound( KVP_DB, 1 ) )
				.Iterator = -1
				.label = Hex( UBound( KVP_DB, 1 ) + 1 )
				.value = Prefix( Chr(32), Buffer )
			End With
		
			Buffer = Suffix( Chr(32), Buffer )
		
		End If
		

	Loop
	
	KVP_Bubble_Sort( KVP_DB ( ) )
	
	KVP_Database_Save( KVP_DB ( ), "./Assets (v0x22)/Words.KVP" )
	
End Sub
	
Sub KVP_Show_Array_Direct ( KVP_DB ( Any ) As KVP_Database )
	
	Dim As String Buff = ""
	Dim As FB.Image Ptr Image
	
	KVP_Show_Array ( KVP_DB ( ), Buff, Image )
	Buff = "" : Image = ImageDestroy2 ( Image )

End Sub

Sub KVP_Show_Array_Bounds ( KVP_DB ( Any ) As KVP_Database )
	
	Color RGBA ( 255, 0, 0, 255 )
	Print "LBound:" & SP & QUOT & LBound ( KVP_DB, 1 ) & QUOT & SP & "To" & SP & "UBound:" & SP & QUOT & UBound ( KVP_DB, 1 ) & QUOT

End Sub

Sub KVP_Show_Array ( KVP_DB ( Any ) As KVP_Database, ByRef Buff As String = "", ByRef Image As FB.Image Ptr = 0 )
	
	Buff = "" : Image = ImageDestroy2 ( Image )
	
	Dim As String KVP_Text_Buffer : KVP_Text_Buffer = ""
	
	For iterator As Long = LBound ( KVP_DB, 1 ) To UBound ( KVP_DB, 1 ) step 1
		With KVP_DB ( iterator )
			KVP_Text_Buffer &= .label & EQ & .value & CRLF
		End With
	Next
	
	Buff = Text_Box_String ( KVP_Text_Buffer, 40, 30 )
	Image = Text_Box_Render ( Buff, 40, 30, 0 )
	
	'Color RGBA ( 255, 64, 64, 255 )
	'Print "KVP Show Array (" & SP & Image -> Width & COMMA & SP & Image -> Height & SP & ")"
	Cls : Put ( 0, 0 ), Image, Alpha : WaitKey ( )


End Sub

Sub __Sort ( KVP_DB ( Any ) As KVP_Database )
	
	KVP_Bubble_Sort ( KVP_DB ( ) )
	
End Sub

Sub KVP_Bubble_Sort ( KVP_DB ( Any ) As KVP_Database )

	'Bubble
	
	Do
		Dim As Long Sorted = 0
		For Iterator As Long = LBound ( KVP_DB, 1 ) To UBound ( KVP_DB, 1 )-1
			If KVP_DB ( Iterator ) .label > KVP_DB(Iterator+1).label Then
				Swap KVP_DB ( Iterator ) .Iterator,KVP_DB(Iterator+1).Iterator
				Swap KVP_DB(Iterator),KVP_DB(Iterator+1)
				Sorted=1
			End If
		Next
		If Sorted = 0 Then Exit Do
	Loop

end sub

Function KVP_Binary_Find ( KVP_DB ( Any ) As KVP_Database , sName As String = "", ByRef WhereToAdd As Long = 0 ) As Long
	
	'Binary
	
	Dim As Long Lo = LBound ( KVP_DB, 1 ), Hi = UBound ( KVP_DB, 1 )
	
	While Hi >= Lo		      
		
		Dim As Long Md = ( Lo + Hi + 1 ) \ 2
		Dim As Long Result = strcmp ( sName , KVP_DB ( Md ) .label )
		
		select case Result
		case 0
			return Md
		case is > 0			
			Lo = Md + 1
		case else
			Hi = Md - 1
		end select
		
	Wend
	
	WhereToAdd = Lo
	
	return -1

end function

Function KVP_Database_Query ( KVP_DB ( Any ) As KVP_Database , sName As String = "" ) As KVP_Database

	var iIndex = KVP_Binary_Find ( KVP_DB ( ) , sName )
	if iIndex >= 0 then return KVP_DB( iIndex ) else return Bogus
	
End Function

Function KVP_Database_Set Overload ( KVP_DB ( Any ) As KVP_Database , sName As String = "" , sValue As String = "" ) As Long

	Dim As Long uNewPos = Any
	
	Var iIndex = KVP_Binary_Find( KVP_DB ( ) , sName , uNewPos )    
	
	If iIndex >= 0 Then 'replace if found
		KVP_DB ( iIndex ) .value = sValue
		Return iIndex
	End if
		
	Dim As Long lo = LBound ( KVP_DB, 1 ), hi = UBound ( KVP_DB, 1 )
	
	If uNewPos <> ( hi + 1 ) Then

		KVP_Inc_Capacity ( KVP_DB ( ), 1 )

		memmove( @KVP_DB( uNewPos + 1 ), @KVP_DB( uNewPos ), ( ( hi - uNewPos ) - 1 ) *sizeof( KVP_DB( 0 ) ) )
		memset( @KVP_DB( uNewPos ), 0, sizeof( KVP_DB( 0 ) ) )
	
	End If
	
	With KVP_DB ( uNewPos )
		.iterator = -1
		.label = sName
		.value = sValue
	End With
	
	return uNewPos    

End function

Function KVP_Database_Set Overload ( KVP_DB ( Any ) As KVP_Database , sName As String = "" , sValue As LongInt = 0 ) As Long

	KVP_Database_Set = KVP_Database_Set ( KVP_DB ( ), sName, Str ( sValue ) )

End Function

Function KVP_Database_Set Overload ( KVP_DB ( Any ) As KVP_Database , sName As String = "" , sValue As FB.Image Ptr ) As Long

	KVP_Database_Set = KVP_Database_Set ( KVP_DB ( ), sName, Str ( @sValue ) )

End Function

Function KVP_Database_Delete ( KVP_DB ( Any ) As KVP_Database , sName As String = "" ) As Long    
	
	var iIndex = KVP_Binary_Find( KVP_DB ( ) , sName )    
	if iIndex<0 then return iIndex 'failed
	with KVP_DB(iIndex)
		.label = "" : .value = "" 'clean strings before delete!!
	end with
	var lo = lbound(KVP_DB), hi = ubound(KVP_DB)    
	memmove( @KVP_DB(iIndex), @KVP_DB(iIndex+1) , ((hi-iIndex))*sizeof(KVP_DB(0)) )
	memset( @KVP_DB(hi) , 0 , sizeof(KVP_DB(0)) )
	
	lo = LBound ( KVP_DB, 1 )
	hi = UBound ( KVP_DB, 1 )

	KVP_Inc_Capacity( KVP_DB ( ), -1 )
	
	return iIndex

End function

Sub KVP_Database_Save ( KVP_DB ( Any ) As KVP_Database, filename As String = "" )
	
	WaitKey  
	
	Dim As String Buffer
	Buffer = ""
	
	KVP_Database_Export( KVP_DB ( ), Buffer )

	WaitKey  

	KVP_Save_Raw_Buffer( Buffer, filename )

	WaitKey  

end sub

Sub KVP_Database_Load ( KVP_DB ( Any ) As KVP_Database, filename As String = "" )
	
	Dim As String Buffer
	Buffer = ""
	
	KVP_Load_Raw_Buffer( Buffer, filename )
	KVP_Database_Import( KVP_DB ( ), Buffer )

end sub

Function KVP_Database_Export ( KVP_DB ( Any ) As KVP_Database, Buffer As String = "" ) As String
		
	'Buffer = ""

	KVP_Bubble_Sort( KVP_DB ( ) )
		
	for Iterator As Long = LBound ( KVP_DB, 1 ) to UBound ( KVP_DB, 1 ) step 1
		
		if KVP_DB ( Iterator ) .label <> "" and KVP_DB ( Iterator ) .value <> "" then

			if len ( Buffer ) > 0 then
			'if(Iterator > LBound ( KVP_DB, 1 )) then
							
				Buffer &= CRLF
			
			end if
						
			Buffer &= KVP_DB ( Iterator ) .label & EQ & KVP_DB ( Iterator ) .value				
			
		end if
		
	next Iterator
	
	Return Buffer
	
end Function

Sub KVP_Database_Import ( KVP_DB ( Any ) As KVP_Database, Buffer As String = "" )
	
	Dim As String KVP_Line
	KVP_Line = ""
	
	KVP_Erase KVP_DB ( )
	
	While Len( Buffer ) > 0
			
		KVP_Line = Prefix( CRLF, Buffer )
		Buffer = Suffix( CRLF, Buffer )
			
		If StrPos( EQ, KVP_Line ) > 0 Then
			
			KVP_Inc_Capacity( KVP_DB ( ), 1 )
		
			With KVP_DB( UBound ( KVP_DB, 1 ) )
				
				.Iterator = -1
				.label = Prefix( EQ, KVP_Line )
				.value = Suffix( EQ, KVP_Line )
				
				Color RGBA ( 63, 255, 63, 255 )
				Print QUOT & .label & QUOT & EQ & QUOT & .value & QUOT
	
				WaitKey ( )

			
			End With
				
		End If
			
	Wend
		
	KVP_Bubble_Sort( KVP_DB ( ) )
	
end sub		

Sub KVP_Save_Raw_Buffer ( Buffer As String = "", filename As String = "" )
		
	If Is_File( Filename ) Then
		Kill Filename
	End If

	dim As Long filemode=freefile
				
	if open(filename for binary As #filemode) then
		close #filemode
		exit sub
	end if
		
	put #filemode,lof(filemode)+1,Buffer
				
	close #Filemode
			
end sub

Sub KVP_Load_Raw_Buffer ( Buffer As String = "", filename As String = "" )

	dim As Long filemode=freefile
	
	if is_file( filename ) then
		
		if open(filename for binary As #filemode) then
			close #filemode
			exit sub
		end if
		
		Buffer = String( lof(filemode), Chr(0) )
		
		If LOF(filemode) > 0 Then
		
			get #filemode, 1, Buffer
		
		End If
		
		close #filemode
				
	end if
	
end sub

Declare function KVP_Request ( KVP_DB ( Any ) as KVP_Database, Request as KVP_Database, Mode as Long ) as KVP_Database

Function KVP_Request ( KVP_DB ( Any ) as KVP_Database, Request as KVP_Database, Mode as Long ) as KVP_Database
	
	dim as Long iterator=-1
	
	select case Mode
	case KVP_DB_CLR
		
		For Iterator = UBOund ( KVP_DB, 1 ) To LBOund ( KVP_DB, 1 ) Step -1
			With KVP_DB ( Iterator )
				.label = ""
				.value = ""
				.iterator = -1
				.image = ImageDestroy2 ( .image )
			End With
			ReDim Preserve KVP_DB ( UBOund ( KVP_DB, 1 ) - 1 To LBOund ( KVP_DB, 1 ) )
		Next Iterator
		erase KVP_DB
		return Bogus
		
	case KVP_DB_GET			

		With Request
			Request = KVP_Database_Query ( KVP_DB ( ), .label )		
		End With

	case KVP_DB_POP
	
		With Request
			.Iterator = KVP_Database_Delete ( KVP_DB ( ), .label )
		End With

		return Bogus					

	case KVP_DB_SET
		
		With Request
			.iterator = KVP_Database_Set ( KVP_DB ( ), .label, .value )
		End With
		
	end select
	
	Return Request
	
End Function

Function __Buffer ( ShortPath As String = "", ShortFilename As String = "" ) As String

	Dim As String Buffer
	Buffer = ""

	Dim As String FullFilename = "..\Story Six (v6-0-1)\Gamepacks\Story 7\" & ShortPath & ShortFilename & ".KVP"

	Select Case UCWords ( ShortPath )
	Case "", "Page", "/Assets/Page/"
		
		ShortPath = "/Assets/Page/"
		
		FullFilename = "..\Story Six (v6-0-1)\Gamepacks\Story 7\" & ShortPath & ShortFilename & ".KVP"
		
	Case "KVP", "/Assets/KVP/"
		
		ShortPath = "/Assets/KVP/"
		
		FullFilename = "..\Story Six (v6-0-1)\Gamepacks\Story 7\" & ShortPath & ShortFilename & ".KVP"
		
	Case Else	
		
		ShortPath = ""
		FullFilename = ShortFilename
		
	End Select
		
	__Buffer = __Direct_Buffer ( FullFilename ) : Return Buffer
	
End Function

Sub __Set_Sleep ( Index As Long = 0, Message As String = "", Value As String = "" ) 
	
	WaitKey  
	
End Sub

Function __Direct_Buffer ( FullFilename As String = "" ) As String
	
	FullFilename = Str_Replace ( "/", "\", FullFilename )

	Dim As String Buffer : Buffer = ""
	
	If Is_File ( FullFilename ) = 0 Then
		WaitKey  
		Buffer = "" : Return Buffer
	End If

	Dim As Long Filemode = Freefile

	If Filemode = 0 Then
		Buffer = "" : Return Buffer
	End If

	If Open ( FullFilename For Binary As #Filemode ) Then
		Close #Filemode
		Filemode = 0
		Buffer = "" : Return Buffer
	End If

	Buffer = Space ( Lof ( Filemode ) )
	Get #Filemode, 1, Buffer
	Close #Filemode
	Filemode = 0
		
	Return Buffer
	
End Function
